## 1. **Functional Planes of Network Devices**

### 1.1. Management Plane

- Handles device management and coordination between data and control planes.
- Prime target for attacks due to its critical functions.

### 1.2. Control Plane

- Processes routing and network infrastructure protocols.
- Maintains network functionality.

### 1.3. Data Plane

- Forwards user data traffic through the device.
- Excludes traffic destined to the device itself.

---

## 2. **Management Access Methods**

### 2.1. Local vs Centralized Management

- **Local (On-box):** Manage one device at a time; suitable for small deployments.
- **Centralized (Off-box):** Manage multiple devices simultaneously; suitable for large networks.

### 2.2. Management Protocols

- **Telnet:** Cleartext, not secure; avoid on untrusted networks.
- **SSH:** Encrypted, secure; recommended for CLI access.
- **NETCONF:** XML-based, uses SSH; secure, validates configurations.
- **HTTP:** Unsecured, cleartext; not recommended for management.
- **HTTPS:** Encrypted, secure; preferred over HTTP for GUI/file transfers.
- **SNMP:**
    - v1/v2c: Cleartext, not recommended over untrusted networks.
    - v3: Encrypted, secure; recommended version.
- **RADIUS/TACACS+:** For AAA (authentication, authorization, accounting); preferred in large deployments.
- **SCP/SFTP:** Secure file transfers; require SSH and AAA.
- **AAA Authentication:** Local database or centralized server (RADIUS/TACACS+).

---

## 3. **Securing Management Access**

### 3.1. Best Practices

- Use secure protocols (SSH, HTTPS, SNMPv3).
- Filter management access by protocol and user.
- Restrict access to only necessary protocols and users.

### 3.2. Access Methods

- **Out-of-Band (OOB):** Separate management network; more secure; used for critical devices.
- **In-Band:** Shares data interfaces; cost-effective but less secure.

### 3.3. Management Plane Threats & Countermeasures

|Threat|Countermeasure|
|---|---|
|Management session spoofing|OOB paths, secure protocols, filtering, cryptography|
|Abuse of management features|AAA, RBAC, authentication, authorization|

---

## 4. **Cisco Device Security Features**

### 4.1. Cisco IOS XE Devices

- **Access Control:** Interface and service-specific ACLs, CPPr, MPP.
- **CPPr (Control Plane Protection):** Protects CPU from excessive traffic using the rate limit. 
- **MPP (Management Plane Protection):** Limits management protocol access to designated interfaces.

### 4.2. Cisco Security Appliances (ASA, Threat Defense)

- Management access restricted to specific interfaces.
- Support secure protocols (SSH, HTTPS, SNMPv3).
- Management rules must be explicitly configured.
- No CPPr; use interface ACLs for filtering.

---

## 5. **Overview of Device Management Methods**
![[Pasted image 20250820205828.png]]

### 5.1. Local Management

- One device at a time.
- Limited scalability and functionality.

### 5.2. Centralized Management

- Manage multiple devices from a single platform.
- Examples: Cisco Secure Firewall Management Center, Cisco Defense Orchestrator, Cisco Security Manager.

---

## 6. **Security Concerns with Common Protocols**

### 6.1. Cisco Discovery Protocol (CDP)

- Shares sensitive device info.
- Should be disabled on interfaces not under your control.

### 6.2. DHCP

- Vulnerable to spoofing and starvation attacks.
- Mitigations: DHCP snooping, port security.

### 6.3. DNS

- Target for phishing/redirection attacks.
- Secure DNS servers and associated infrastructure.

---

## 7. **Additional Notes**

- Use OOB management for critical assets.
- Apply least privilege principle with RBAC and AAA.
- Regularly update and patch management protocols and device firmware.
- Disable unused protocols and services.
- Implement granular ACLs and monitoring for management traffic.

---

### **Examples**

- **SSH for CLI Management:** Enable SSH, disable Telnet, use key-based authentication.
- **Centralized AAA:** Integrate device management with Active Directory for scalable authentication.
- **OOB Management:** Use dedicated management interfaces connected to a separate network for sensitive devices.

---

**Edge Cases and Considerations**

- Some devices may not support all management methods.
- Balance between security and operational requirements (e.g., OOB vs. in-band).
- Ensure management network is physically and logically isolated where possible.